#!/bin/bash

set -x

nstep=$1

# params for grain_growth_1024
# lshK=5
# lshL=3
# lshr=0.8

lshK=10
lshL=3
lshr=0.8

python_folder=../python_simulation

#grain_growth_input=output/grain_growth_n64_init3.in
#grain_growth_input=output/grain_growth_n1024_init3.in
# grain_growth_input=output/grain_growth_n4096_init3.in
grain_growth_input=../data_128
chash_output=output/grain_growth_n4096_chash_ns${nstep}_K${lshK}_L${lshL}_r${lshr}.out
bucket_output=output/grain_growth_n4096_chash_bucket_ns${nstep}_K${lshK}_L${lshL}_r${lshr}.out

python_output=output/python_grain_growth_n4096_exact_ns${nstep}.out

## run 
# ./test_grain_growth --nsteps $nstep --lshK $lshK --lshL $lshL --lshr $lshr --input $grain_growth_input --output $chash_output --bucket_output $bucket_output

# python $python_folder/grain_growth.py --input $grain_growth_input --output $python_output --nsteps $nstep

# python $python_folder/display_simulated_grain_growth_top_down.py --result1 $chash_output --result2 $python_output
# rm log_1
# rm log_2
# make clean

rm log_show
make gg_show
./gg_show --nsteps $nstep --lshK $lshK --lshL $lshL --lshr $lshr --input $grain_growth_input --output $chash_output --bucket_output $bucket_output > log_show &

# rm log_show_torch
# make gg_show_torch
# ./gg_show_torch --nsteps $nstep --lshK $lshK --lshL $lshL --lshr $lshr --input $grain_growth_input --output $chash_output --bucket_output $bucket_output > log_show_torch &
